/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.RepairFactorModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record RepairModule(float flat, float leveling) implements RepairFactorModifierHook,
ModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.REPAIR_FACTOR);
    public static final GenericLoaderRegistry.IGenericLoader<RepairModule> LOADER = new GenericLoaderRegistry.IGenericLoader<RepairModule>(){

        @Override
        public RepairModule deserialize(JsonObject json) {
            float flat = class_3518.method_15277((JsonObject)json, (String)"flat", (float)0.0f);
            float leveling = class_3518.method_15277((JsonObject)json, (String)"leveling", (float)0.0f);
            return new RepairModule(flat, leveling);
        }

        @Override
        public void serialize(RepairModule object, JsonObject json) {
            if (object.flat != 0.0f) {
                json.addProperty("flat", (Number)Float.valueOf(object.flat));
            }
            if (object.leveling != 0.0f) {
                json.addProperty("leveling", (Number)Float.valueOf(object.leveling));
            }
        }

        @Override
        public RepairModule fromNetwork(class_2540 buffer) {
            float flat = buffer.readFloat();
            float leveling = buffer.readFloat();
            return new RepairModule(flat, leveling);
        }

        @Override
        public void toNetwork(RepairModule object, class_2540 buffer) {
            buffer.writeFloat(object.flat);
            buffer.writeFloat(object.leveling);
        }
    };

    @Override
    public float getRepairFactor(IToolStackView tool, ModifierEntry entry, float factor) {
        return factor *= 1.0f + entry.getEffectiveLevel(tool) * this.leveling + this.flat;
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static RepairModule flat(float value) {
        return new RepairModule(value, 0.0f);
    }

    public static RepairModule leveling(float leveling) {
        return new RepairModule(0.0f, leveling);
    }
}

